<?php
require '../config.php';

$categories = $conn->query("SELECT * FROM categories")->fetch_all(MYSQLI_ASSOC);
$cuts = $conn->query("SELECT cuts.*, categories.name as category_name FROM cuts JOIN categories ON cuts.category_id = categories.id ORDER BY cuts.name")->fetch_all(MYSQLI_ASSOC);
$messages = $conn->query("SELECT content FROM messages")->fetch_all(MYSQLI_ASSOC);
$chamaSenhaSetting = $conn->query("SELECT value FROM settings WHERE name = 'chama_senha'")->fetch_assoc()['value'];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Display</title>
    <link rel="stylesheet" href="styles.css">
    <style>
        /* Estilo global */
        body {
            font-family: Arial, sans-serif;
            background-color: #000;
            background-image: url('background.jpg');
            background-size: cover;
            background-position: center;
            color: #fff;
            margin: 0;
            padding: 0;
            display: flex;
            flex-direction: column;
            align-items: center;
            height: 100vh;
        }

        /* Estilo do cabeçalho */
        header {
            background-color: rgba(178, 34, 34, 0.8);
            width: 100%;
            text-align: center;
            padding: 20px 0;
            display: flex;
            flex-direction: column;
            align-items: center;
        }

        header h1 {
            margin: 0;
            font-size: 4em;
            font-family: 'Lobster', cursive;
            color: #fff;
        }

        /* Estilo do conteúdo */
        .content {
            width: 80%;
            margin: 20px 0;
            background-color: rgba(0, 0, 0, 0.5);
            padding: 20px;
            border-radius: 10px;
            position: relative;
            z-index: 1;
        }

        .category {
            display: none;
            margin-bottom: 20px;
        }

        .category h2 {
            background-color: rgba(178, 34, 34, 0.8);
            padding: 10px;
            margin: 0;
            border-radius: 5px 5px 0 0;
            text-align: center;
            font-size: 2.5em;
        }

        .category ul {
            list-style: none;
            padding: 0;
            margin: 0;
            border: 1px solid rgba(178, 34, 34, 0.8);
            border-radius: 0 0 5px 5px;
        }

        .category li {
            background-color: rgba(26, 26, 26, 0.7);
            padding: 15px;
            border-bottom: 1px solid #333;
            font-size: 2em;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .cut-name {
            text-align: left;
        }

        .cut-price {
            text-align: right;
        }

        .category li:last-child {
            border-bottom: none;
        }

        /* Estilo do rodapé */
        footer {
            width: 100%;
            text-align: center;
            padding: 10px;
            background-color: rgba(178, 34, 34, 0.8);
            color: #fff;
            position: fixed;
            bottom: 0;
            display: flex;
            flex-direction: column;
            align-items: center;
        }

        .messages {
            font-size: 2em;
            color: #fff;
        }

        .senha-container {
            margin-top: auto;
            font-size: 1.5em;
            text-align: left;
            width: 80%;
            margin-bottom: 150px;
        }

        .senha-table {
            width: 100%;
            border-collapse: collapse;
        }

        .senha-table td {
            padding: 10px;
            border: none;
            text-align: left;
            font-size: 2em;
            color: #000; /* Texto em preto */
            background-color: #fff; /* Fundo branco */
        }

        .senha-historico {
            font-size: 1em;
            margin-top: 10px;
            color: #000; /* Texto em preto */
            background-color: #fff; /* Fundo branco */
            padding: 10px;
            border-radius: 5px;
            display: inline-block;
        }

        .senha-btn {
            background-color: #b22222;
            color: #fff;
            border: none;
            padding: 15px 30px;
            font-size: 2em;
            cursor: pointer;
        }

        .senha-display {
            font-size: 2em;
            font-weight: bold;
            color: #000; /* Texto em preto */
            background-color: #fff; /* Fundo branco */
            padding: 10px;
            border-radius: 5px;
            margin-left: 20px;
            display: inline-block;
        }
    </style>
</head>
<body>
    <header>
        <h1>SUPERMERCADO REAL PENTA</h1>
    </header>
    <div class="content">
        <?php foreach ($categories as $index => $category): ?>
        <div class="category" id="category-<?= $index ?>" <?php if ($index == 0) echo 'style="display:block;"'; ?>>
            <h2><?= htmlspecialchars($category['name']) ?></h2>
            <ul>
                <?php foreach ($cuts as $cut): ?>
                    <?php if ($cut['category_id'] == $category['id']): ?>
                    <li>
                        <span class="cut-name"><?= htmlspecialchars($cut['name']) ?></span>
                        <span class="cut-price"><?= htmlspecialchars(number_format($cut['price'], 2, ',', '.')) ?></span>
                    </li>
                    <?php endif; ?>
                <?php endforeach; ?>
            </ul>
        </div>
        <?php endforeach; ?>
    </div>
    <?php if ($chamaSenhaSetting): ?>
    <div class="senha-container" id="senha-container">
        <table class="senha-table">
            <tr>
                <td><button id="senha-btn" class="senha-btn">SENHA:</button><span id="senha-display" class="senha-display"></span></td>
            </tr>
        </table>
        <div class="senha-historico" id="senha-historico"></div>
        <input type="text" id="senha-input" style="display: none;">
    </div>
    <audio id="bell-sound" src="bell.mp3" preload="auto"></audio>
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            var senhaInput = document.getElementById('senha-input');
            var senhaDisplay = document.getElementById('senha-display');
            var senhaHistorico = document.getElementById('senha-historico');
            var bellSound = document.getElementById('bell-sound');
            var senhaBtn = document.getElementById('senha-btn');
            var historico = [];
            var lastSenha = 0;

            function atualizarSenha(senha) {
                historico.unshift(senha);
                if (historico.length > 3) historico.pop();
                senhaDisplay.textContent = senha;
                senhaHistorico.innerHTML = 'Últimas Senhas: ' + historico.join(' | ');
                lastSenha = senha;
                bellSound.play().catch(function() {
                    // Em caso de erro, tentar tocar novamente
                    bellSound.play();
                });
            }

            senhaInput.addEventListener('keydown', function(event) {
                if (event.key === 'Enter') {
                    var senha = senhaInput.value;
                    if (senha === '') {
                        senha = (parseInt(lastSenha) + 1).toString();
                    }
                    atualizarSenha(senha);
                    senhaInput.value = '';
                    senhaInput.style.display = 'none';
                }
            });

            document.addEventListener('keydown', function(event) {
                if (event.key === 'Enter' && senhaInput.style.display === 'none') {
                    senhaInput.style.display = 'block';
                    senhaInput.value = '';
                    senhaInput.focus();
                    event.preventDefault();
                } else if (event.key === '0' && senhaInput.style.display === 'none') {
                    atualizarSenha((parseInt(lastSenha) + 1).toString());
                }
            });

            senhaBtn.addEventListener('click', function() {
                atualizarSenha((parseInt(lastSenha) + 1).toString());
            });

            document.addEventListener('click', function(event) {
                if (event.target !== senhaBtn && senhaInput.style.display === 'none') {
                    atualizarSenha((parseInt(lastSenha) + 1).toString());
                }
            });

            document.addEventListener('wheel', function(event) {
                if (event.deltaY < 0 && senhaInput.style.display === 'none') {
                    atualizarSenha((parseInt(lastSenha) + 1).toString());
                }
            });
        });
    </script>
    <?php endif; ?>
<footer>
        <div class="messages" id="messages">
            <?php foreach ($messages as $index => $message): ?>
                <p class="message" id="message-<?= $index ?>" <?php if ($index != 0) echo 'style="display:none;"'; ?>><?= htmlspecialchars($message['content']) ?></p>
            <?php endforeach; ?>
        </div>
    </footer>
    <script>
        // Script para alternar categorias a cada 30 segundos
        var currentCategoryIndex = 0;
        var categories = document.querySelectorAll('.category');

        function showNextCategory() {
            categories[currentCategoryIndex].style.display = 'none';
            currentCategoryIndex = (currentCategoryIndex + 1) % categories.length;
            categories[currentCategoryIndex].style.display = 'block';
        }

        setInterval(showNextCategory, 30000); // 30000ms = 30s

        // Script para alternar mensagens a cada 30 segundos
        var currentMessageIndex = 0;
        var messages = document.querySelectorAll('.message');

        function showNextMessage() {
            messages[currentMessageIndex].style.display = 'none';
            currentMessageIndex = (currentMessageIndex + 1) % messages.length;
            messages[currentMessageIndex].style.display = 'block';
        }

        setInterval(showNextMessage, 30000); // 30000ms = 30s

        document.addEventListener("DOMContentLoaded", function() {
            var senhaInput = document.getElementById('senha-input');
            var senhaDisplay = document.getElementById('senha-display');
            var senhaHistorico = document.getElementById('senha-historico');
            var bellSound = document.getElementById('bell-sound');
            var senhaBtn = document.getElementById('senha-btn');
            var historico = [];
            var lastSenha = 0;

            function atualizarSenha(senha) {
                historico.unshift(senha);
                if (historico.length > 3) historico.pop();
                senhaDisplay.textContent = senha;
                senhaHistorico.innerHTML = 'Últimas Senhas: ' + historico.join(' | ');
                lastSenha = senha;
                bellSound.play().catch(function() {
                    // Em caso de erro, tentar tocar novamente
                    bellSound.play();
                });
            }

            senhaInput.addEventListener('keydown', function(event) {
                if (event.key === 'Enter') {
                    var senha = senhaInput.value;
                    if (senha === '') {
                        senha = (parseInt(lastSenha) + 1).toString();
                    }
                    atualizarSenha(senha);
                    senhaInput.value = '';
                    senhaInput.style.display = 'none';
                }
            });

            document.addEventListener('keydown', function(event) {
                if (event.key === 'Enter' && senhaInput.style.display === 'none') {
                    senhaInput.style.display = 'block';
                    senhaInput.value = '';
                    senhaInput.focus();
                    event.preventDefault();
                } else if (event.key === '0' && senhaInput.style.display === 'none') {
                    atualizarSenha((parseInt(lastSenha) + 1).toString());
                }
            });

            senhaBtn.addEventListener('click', function() {
                atualizarSenha((parseInt(lastSenha) + 1).toString());
            });

            document.addEventListener('click', function(event) {
                if (event.target !== senhaBtn && senhaInput.style.display === 'none') {
                    atualizarSenha((parseInt(lastSenha) + 1).toString());
                }
            });

            document.addEventListener('wheel', function(event) {
                if (event.deltaY < 0 && senhaInput.style.display === 'none') {
                    atualizarSenha((parseInt(lastSenha) + 1).toString());
                }
            });
        });
    </script>
</body>
</html>